## distribution (in group)

Contained in [group](https://docs.vespa.ai/en/reference/services-content.html#group). Defines the data distribution to subgroups of this group. *distribution* should not be in the lowest level group containing storage nodes, as here the ideal state algorithm is used directly. In higher level groups, *distribution* is mandatory.

| Attribute  |                   Required                   | Value  | Default |                                                                                                                                                                                                     Description                                                                                                                                                                                                      |
|------------|----------------------------------------------|--------|---------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| partitions | required if there are subgroups in the group | string |         | String conforming to the partition specification: | Partition specification |               Description                | |-------------------------|------------------------------------------| | \*                      | Distribute all copies over 1 of N groups | | 1\|\*                   | Distribute all copies over 2 of N groups | | 1\|1\|\*                | Distribute all copies over 3 of N groups | |

The partition specification is used to evenly distribute content copies across groups. Set a number or `*` per group separated by pipes (e.g. `1|*` for two groups). See [sample deployment configurations](https://docs.vespa.ai/en/performance/sizing-examples.html).
[Read more](https://docs.vespa.ai/en/reference/services-content.html#distribution)
